<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Venuegallery extends MX_Controller {
	public $table = "venue_gallery";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("venuegallery_model");
		
		$this->load->model("eventvenue/Eventvenue_model");	
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="vgactive";
			$this->load->view('dashboard/header',$data);	
			$venue=$this->venuegallery_model->getAllbanners();
			$data["venue"]=$venue;
			$this->load->view('venuegallery1',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createvenuegallery()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="vgactive";
			$this->load->view('dashboard/header',$data);
			$venues=$this->Eventvenue_model->getAllbanners();
			$data["venues"]=$venues;			
			$this->load->view('create-venuegallery',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function savevenuegallery()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$venue=explode(".",$_FILES["mainImage"]["name"]);
			$bannersimg=time().".".end($venue);		
			
			$params=array( 
				'venue_id' => $this->input->post("venue_id"),
				'image_title' => $this->input->post("image_title"),			
				'venue_image' => $bannersimg,				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}venue_gallery";
			$venue=$this->venuegallery_model->storeItems($table,$params);
			if($venue == 1)
			{
				
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/venues/".$bannersimg);		
				
				$success_categories=array(
					'success_categories' => "Successfully venue Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/venuegallery");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create venue."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/venuegallery");
			}					
			
		}
	}	
	
	public function editvenuegallery($venuegalleryid)
	{
		$venuegalleryid=str_replace("_","=",base64_decode($venuegalleryid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="vgactive";
			$this->load->view('dashboard/header',$data);
			$data["venuegalleryid"]=$venuegalleryid;
			$venue=$this->venuegallery_model->getvenuegalleryid($venuegalleryid);
			$data["venue"]=$venue;
			//print_r($venue);die();
			$venues=$this->Eventvenue_model->getAllbanners();
			$data["venues"]=$venues;			
			$this->load->view('edit-venuegallery',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatevenuegallery()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$venuegalleryid=$this->input->post("venuegalleryid");
			
			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannersimg=time().".".end($category);
			
				$deleteExistimage=$this->venuegallery_model->removeExistsimage($venuegalleryid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/venues/".$bannersimg);
				}
				else
				{
					$this->session->set_userdata($err_msg);
					redirect(base_url()."index.php/venuegallery/editeventvenue/".str_replace("=","_",base64_encode($venuegalleryid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}	
			
			$params=array(
				'venue_id' => $this->input->post("venue_id"),
				'image_title' => $this->input->post("image_title"),			
				'venue_image' => $bannersimg,	
			);
			//print_r($params);die();
			$table="{PRE}venue_gallery";
			$venue=$this->venuegallery_model->updateItems($table,$params,$venuegalleryid);
			if($venue == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Venue Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/venuegallery");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update Venue."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/venuegallery");
			}
			
		}
	}
	
	
	public function deletevenuegallery($venuegalleryid)
	{
		$venuegalleryid=str_replace("_","=",base64_decode($venuegalleryid));
		$venue=$this->venuegallery_model->deletevenuegallery($venuegalleryid);
		if($venue == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/venuegallery");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/venuegallery");
		}
		
	}
	
	public function inactiveItem($venuegalleryid)
	{
		//$venuegalleryid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->venuegallery_model->itemStatusMode($this->table,$params,$venuegalleryid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/venuegallery");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/venuegallery");
		}
	}
	
	public function activeItem($venuegalleryid)
	{
		//$venuegalleryid=str_replace("_","=",base64_decode($venuegalleryid));
		$params=array(
			"status" => 1
		);
		$success=$this->venuegallery_model->itemStatusMode($this->table,$params,$venuegalleryid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/venuegallery");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/venuegallery");
		}
	}
	
	
	
	
}

