<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Abstractcontent extends MX_Controller {
	public $table = "guidelines";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("abstractcontent_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="absactive";
			$this->load->view('dashboard/header',$data);	
			$abstractcontent=$this->abstractcontent_model->getAllbanners();
			$data["abstractcontent"]=$abstractcontent;
			$this->load->view('abstractcontent',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createabstractcontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="absactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createabstractcontent');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveabstractcontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$pagetype="2";
			$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
			'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$abstractcontent=$this->abstractcontent_model->storeItems($table,$params);
			if($abstractcontent == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/abstractcontent");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/abstractcontent");
			}					
			
		}
	}	
	
	public function editabstractcontent($abstractcontentid)
	{
		$abstractcontentid=str_replace("_","=",base64_decode($abstractcontentid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="absactive";
			$this->load->view('dashboard/header',$data);
			$data["abstractcontentid"]=$abstractcontentid;
			$abstractcontent=$this->abstractcontent_model->getabstractcontentid($abstractcontentid);
			$data["abstractcontent"]=$abstractcontent;
			//print_r($abstractcontent);die();
	
			$this->load->view('editabstractcontent',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateabstractcontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$abstractcontentid=$this->input->post("abstractcontentid");
				$pagetype="2";
				$params=array(
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$abstractcontent=$this->abstractcontent_model->updateItems($table,$params,$abstractcontentid);
			if($abstractcontent == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  abstractcontent Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/abstractcontent");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update abstractcontent."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/abstractcontent");
			}
			
		}
	}
	
	
	public function deleteabstractcontent($abstractcontentid)
	{
		$abstractcontentid=str_replace("_","=",base64_decode($abstractcontentid));		
		$abstractcontent=$this->abstractcontent_model->deleteabstractcontent($abstractcontentid);
		if($abstractcontent == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
		
	}
	
	public function inactiveItem($abstractcontentid)
	{
		//$abstractcontentid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->abstractcontent_model->itemStatusMode($this->table,$params,$abstractcontentid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
	}
	
	public function activeItem($abstractcontentid)
	{
		//$abstractcontentid=str_replace("_","=",base64_decode($abstractcontentid));
		$params=array(
			"status" => 1
		);
		$success=$this->abstractcontent_model->itemStatusMode($this->table,$params,$abstractcontentid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/abstractcontent");
		}
	}
	
	
	
	
}

