<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Accommodation extends MX_Controller {
	public $table = "accommodation";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("accommodation_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="acdactive";
			$this->load->view('dashboard/header',$data);	
			$accommodation=$this->accommodation_model->getAllbanners();
			$data["accommodation"]=$accommodation;
			$this->load->view('accommodation',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createaccommodation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="acdactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-accommodation');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveaccommodation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'accommodation' => $this->input->post("accommodation"),
				'single_occupancy' => $this->input->post("single_occupancy"),
                'single_occupancy_amount' => $this->input->post("single_occupancy_amount"),
                'double_occupancy' => $this->input->post("double_occupancy"),
                'double_occupancy_amount' => $this->input->post("double_occupancy_amount"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}accommodation";
			$accommodation=$this->accommodation_model->storeItems($table,$params);
			if($accommodation == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully accommodation Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/accommodation");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create accommodation."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/accommodation");
			}					
			
		}
	}	
	
	public function editaccommodation($accommodationid)
	{
		$accommodationid=str_replace("_","=",base64_decode($accommodationid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="acdactive";
			$this->load->view('dashboard/header',$data);
			$data["accommodationid"]=$accommodationid;
			$table = 'accommodation';
			$accommodation=$this->accommodation_model->getaccommodationid($table,$accommodationid);
			$data["accommodation"]=$accommodation;
			//print_r($accommodation);die();
			
			$this->load->view('edit-accommodation',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateaccommodation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$accommodationid = $this->input->post("accommodationid");
			
			$params=array(
				
				'accommodation' => $this->input->post("accommodation"),
				'single_occupancy' => $this->input->post("single_occupancy"),
                'single_occupancy_amount' => $this->input->post("single_occupancy_amount"),
                'double_occupancy' => $this->input->post("double_occupancy"),
                'double_occupancy_amount' => $this->input->post("double_occupancy_amount"),
			);
			//print_r($params);die();
			$table="{PRE}accommodation";
			$accommodation=$this->accommodation_model->updateItems($table,$params,$accommodationid);
			if($accommodation == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully accommodation Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/accommodation");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update accommodation."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/accommodation");
			}
			
		}
	}
	
	
	public function deleteaccommodation($accommodationid)
	{
		$accommodationid=str_replace("_","=",base64_decode($accommodationid));
		$accommodation=$this->accommodation_model->deleteaccommodation($accommodationid);
		if($accommodation == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/accommodation");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/accommodation");
		}
		
	}
	
	public function inactiveItem($accommodationid)
	{
		//$accommodationid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->accommodation_model->itemStatusMode($this->table,$params,$accommodationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/accommodation");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/accommodation");
		}
	}
	
	public function activeItem($accommodationid)
	{
		//$accommodationid=str_replace("_","=",base64_decode($accommodationid));
		$params=array(
			"status" => 1
		);
		$success=$this->accommodation_model->itemStatusMode($this->table,$params,$accommodationid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/accommodation");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/accommodation");
		}
	}
	
	
	
	
	
}

