<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Membercount extends MX_Controller {
	public $table = "static_data";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("membercount_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="mcactive";
			$this->load->view('dashboard/header',$data);	
			$designation=$this->membercount_model->getAllbanners();
			$data["designation"]=$designation;
			//print_r($designation);
			$this->load->view('membercount',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createdesignation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="deactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-membercount');
			$this->load->view('dashboard/footer');
		}
	}
	public function savedesignation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$params=array(
				
				'name' => $this->input->post("member"),							
				'number' => $this->input->post("count"),	
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}static_data";
			$designation=$this->membercount_model->storeItems($table,$params);
			if($designation == 1)
			{			
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/membercount");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/membercount");
			}					
			
		}
	}	
	
	public function editdesignation($designationid)
	{
		$designationid=str_replace("_","=",base64_decode($designationid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="deactive";
			$this->load->view('dashboard/header',$data);
			$data["designationid"]=$designationid;
			$designation=$this->membercount_model->getdesignationid($designationid);
			$data["designation"]=$designation;
			//print_r($designation);die();
		
			$this->load->view('edit-membercount',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatedesignation()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$designationid=$this->input->post("designationid");

			$params=array(
				
				'name' => $this->input->post("member"),							
				'number' => $this->input->post("count"),							
							
				
			);
			
			$table="{PRE}static_data";
			$designation=$this->membercount_model->updateItems($table,$params,$designationid);
			
			if($designation == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/membercount");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/membercount");
			}
			
		}
	}
	
	
	public function deletedesignation($designationid)
	{
		$designationid=str_replace("_","=",base64_decode($designationid));
		$designation=$this->membercount_model->deletedesignation($designationid);
		if($designation == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/membercount");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/membercount");
		}
		
	}
	
	
	
	
	
	
}

