<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mentors extends MX_Controller {
	public $table = "about_us_mentors";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("mentors_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			$mentors=$this->mentors_model->getAllbanners();
			$data["mentors"]=$mentors;
			$this->load->view('mentors',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function creatementors()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$this->load->view('create-mentors');
			$this->load->view('dashboard/footer');
		}
	}
	public function savementors()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$mentors=explode(".",$_FILES["mainImage"]["name"]);
			$bannersimg=time().".".end($mentors);
			
			$params=array(
				'mentor_name' => $this->input->post("mentor_name"),
				'mentor_designation' => $this->input->post("mentor_designation"),											
				'mentor_image' => $bannersimg,
				'created_date' => $this->input->post("mentor_designation1"),					
			);
			//print_r($params);die();
			$table="{PRE}about_us_mentors";
			$mentors=$this->mentors_model->storeItems($table,$params);
			if($mentors == 1)
			{
				@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/aboutus/".$bannersimg);		
				$success_categories=array(
					'success_categories' => "Successfully mentors Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/mentors");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create mentors."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/mentors");
			}					
			
		}
	}	
	
	public function editmentors($mentorsid)
	{
		$mentorsid=str_replace("_","=",base64_decode($mentorsid));
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$data["mentorsid"]=$mentorsid;
			$mentors=$this->mentors_model->getmentorsid($mentorsid);
			$data["mentors"]=$mentors;
			//print_r($mentors);die();
			$this->load->view('edit-mentors',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatementors()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			 $mentorsid=$this->input->post("mentorsid");
			
			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannersimg=time().".".end($category);
			
				$deleteExistimage=$this->mentors_model->removeExistsimage($mentorsid);
				if($deleteExistimage == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/aboutus/".$bannersimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Failed to Update mentors."
				);
				$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/mentors/editmentors/".str_replace("=","_",base64_encode($mentorsid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}	
			
			$params=array(
				
				'mentor_name' => $this->input->post("mentor_name"),
				'mentor_designation' => $this->input->post("mentor_designation"),											
				'created_date' => $this->input->post("mentor_designation1"),											
				'mentor_image' => $bannersimg,				
			);
			//print_r($params);die();
			$table="{PRE}about_us_mentors";
			$mentors=$this->mentors_model->updateItems($table,$params,$mentorsid);
			if($mentors == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully mentors Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/mentors");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update mentors."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/mentors");
			}
			
		}
	}
	
	
	public function deletementors($mentorsid)
	{
		$mentorsid=str_replace("_","=",base64_decode($mentorsid));

		$mentors=$this->mentors_model->deletementors($mentorsid);
		if($mentors == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentors");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentors");
		}
		
	}
	
	public function inactiveItem($mentorsid)
	{
		//$mentorsid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->mentors_model->itemStatusMode($this->table,$params,$mentorsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentors");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentors");
		}
	}
	
	public function activeItem($mentorsid)
	{
		//$mentorsid=str_replace("_","=",base64_decode($mentorsid));
		$params=array(
			"status" => 1
		);
		$success=$this->mentors_model->itemStatusMode($this->table,$params,$mentorsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/mentors");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/mentors");
		}
	}
	
	
	
	
}

