<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Metadesc extends MX_Controller {
	public $table = "metadesc";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("metadesc_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="metactive";
			$this->load->view('dashboard/header',$data);	
			$metadesc=$this->metadesc_model->getAllbanners();
			$data["metadesc"]=$metadesc;
			$this->load->view('metadesc',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createmetadesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="metactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-metadesc');
			$this->load->view('dashboard/footer');
		}
	}
	public function savemetadesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$params=array(
				'page_title' => $this->input->post("page_title"),
				'meta_desc' => $this->input->post("meta_desc"),				
				'meta_key_words' => $this->input->post("meta_key_words"),				
				'meta_title' => $this->input->post("meta_title"),				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}metadesc";
			$metadesc=$this->metadesc_model->storeItems($table,$params);
			if($metadesc == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully metadesc Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/metadesc/createmetadesc");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create metadesc."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/metadesc/createmetadesc");
			}					
			
		}
	}	
	
	public function editmetadesc($metadescid)
	{
		$metadescid=str_replace("_","=",base64_decode($metadescid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="metactive";
			$this->load->view('dashboard/header',$data);
			$data["metadescid"]=$metadescid;
			$metadesc=$this->metadesc_model->getmetadescid($metadescid);
			$data["metadesc"]=$metadesc;
			//print_r($metadesc);die();
		
			$this->load->view('edit-metadesc',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatemetadesc()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			
			$metadescid = $this->input->post("metadescid");
			$params=array(
			
				'page_title' => $this->input->post("page_title"),
				'meta_desc' => $this->input->post("meta_desc"),				
				'meta_key_words' => $this->input->post("meta_key_words"),
				'meta_title' => $this->input->post("meta_title"),													
			);
			//print_r($params);die();
			$table="{PRE}metadesc";
			$metadesc=$this->metadesc_model->updateItems($table,$params,$metadescid);
			if($metadesc == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully metadesc Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/metadesc");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update metadesc."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/metadesc");
			}
			
		}
	}
	
	
	public function deletemetadesc($metadescid)
	{
		$metadescid=str_replace("_","=",base64_decode($metadescid));
		$metadesc=$this->metadesc_model->deletemetadesc($metadescid);
		if($metadesc == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/metadesc");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/metadesc");
		}
		
	}
	
	public function inactiveItem($metadescid)
	{
		//$metadescid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->metadesc_model->itemStatusMode($this->table,$params,$metadescid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/metadesc");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/metadesc");
		}
	}
	
	public function activeItem($metadescid)
	{
		//$metadescid=str_replace("_","=",base64_decode($metadescid));
		$params=array(
			"status" => 1
		);
		$success=$this->metadesc_model->itemStatusMode($this->table,$params,$metadescid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/metadesc");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/metadesc");
		}
	}
	
	
	
	
}

