<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class News extends MX_Controller {
	public $table = "why_how";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("news_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="lnactive";
			$this->load->view('dashboard/header',$data);	
			$news=$this->news_model->getAllbanners();
			$data["news"]=$news;
			$this->load->view('news',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createnews()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="lnactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('createnews');
			$this->load->view('dashboard/footer');
		}
	}
	public function savenews()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			//$news=explode(".",$_FILES["mainImage"]["name"]);
			//$bannersimg=time().".".end($news);		
			$bannerdate=$this->input->post('newsdate');
			$params=array(
				'pagetype' => $this->input->post("page_type"),
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),				
				'newsdate'=>@date('Y-m-d', strtotime($bannerdate)),
				'created_date' => @date("Y-m-d H:i:s"),	
				'conf_time' => $this->input->post("conf_time"),	
				'sort_o' => $this->input->post("sort"),	
			);
			//print_r($params);die();
			$table="{PRE}latest_news";
			$news=$this->news_model->storeItems($table,$params);
			if($news == 1)
			{
				
				//@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/whyandhow/".$bannersimg);		
				
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/news");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create whyandhow."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/news");
			}					
			
		}
	}	
	
	public function editnews($newsid)
	{
		$newsid=str_replace("_","=",base64_decode($newsid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="lnactive";
			$this->load->view('dashboard/header',$data);
			$data["newsid"]=$newsid;
			$news=$this->news_model->getnewsid($newsid);
			$data["news"]=$news;
			//print_r($news);die();			
			$this->load->view('editnews',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatenews()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
		  //  print_r("str");
			$newsid=$this->input->post("newsid");
			$bannerdate=$this->input->post('newsdate');
			$params=array(
				
				'pagetype' => $this->input->post("page_type"),
				'title' => $this->input->post("title"),
				'description' => $this->input->post("description"),				
				'newsdate'=>@date('Y-m-d', strtotime($bannerdate)),
				'created_date' => @date("Y-m-d H:i:s"),	
				'conf_time' => $this->input->post("conf_time"),	
				'sort_o' => $this->input->post("sort"),					
			);
// 			print_r($params);die();
			$table="{PRE}latest_news";
			$news=$this->news_model->updateItems($table,$params,$newsid);
// 			$str = $this->db->last_query();
 			// print_r($str);die();
			if($news == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  News Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/news");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update news."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/news");
			}
			
		}
	}
	
	
	public function deletenews($newsid)
	{
		$newsid=str_replace("_","=",base64_decode($newsid));
		$news=$this->news_model->deletenews($newsid);
		if($news == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/news");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/news");
		}
		
	}
	
	public function inactiveItem($newsid)
	{
		//$whyandhowid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->news_model->itemStatusMode($this->table,$params,$newsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/news");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/news");
		}
	}
	
	public function activeItem($newsid)
	{
		//$whyandhowid=str_replace("_","=",base64_decode($whyandhowid));
		$params=array(
			"status" => 1
		);
		$success=$this->news_model->itemStatusMode($this->table,$params,$newsid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/whyandhow");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/whyandhow");
		}
	}
	
	
	
	
}

