<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Scholarships extends MX_Controller {
	public $table = "guidelines";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("scholarships_model");	
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="schactive";
			$this->load->view('dashboard/header',$data);	
			$description=$this->scholarships_model->getAllbanners();
			$data["description"]=$description;
			//print_r($description);
			$this->load->view('scholarships',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createcontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="schactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('create-content');
			$this->load->view('dashboard/footer');
		}
	}
	public function savecontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$pagetype="3";
			$params=array(
				
				'title' => $this->input->post("title"),							
				'description' => $this->input->post("description"),							
				'pagetype' => $pagetype,							
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}guidelines";
			$description=$this->scholarships_model->storeItems($table,$params);
			if($description == 1)
			{			
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/scholarships");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/scholarships");
			}					
			
		}
	}	
	
	public function editcontent($descriptionid)
	{
		$descriptionid=str_replace("_","=",base64_decode($descriptionid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="schactive";
			$this->load->view('dashboard/header',$data);
			$data["descriptionid"]=$descriptionid;
			$description=$this->scholarships_model->getdescriptionid($descriptionid);
			$data["description"]=$description;
			//print_r($description);die();
		
			$this->load->view('edit-content',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatecontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$descriptionid=$this->input->post("descriptionid");
			$pagetype="3";
			$params=array(
				
				'title' => $this->input->post("title"),							
				'description' => $this->input->post("description"),							
				'pagetype' => $pagetype,
			);
			
			$table="{PRE}guidelines";
			$description=$this->scholarships_model->updateItems($table,$params,$descriptionid);
			if($description == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/scholarships");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/scholarships");
			}
			
		}
	}
	
	
	public function deletecontent($descriptionid)
	{
		$descriptionid=str_replace("_","=",base64_decode($descriptionid));
		$description=$this->scholarships_model->deletecontent($descriptionid);
		if($description == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/scholarships");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/scholarships");
		}
		
	}
	
	
	
	
	
	
}

