<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Speaker extends MX_Controller {
	public $table = "speakers";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("speaker_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="spactive";
			$this->load->view('dashboard/header',$data);	
			$speaker=$this->speaker_model->getAllbanners();
			$data["speaker"]=$speaker;
			$this->load->view('speaker',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createspeaker()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="spactive";
			$this->load->view('dashboard/header',$data);			
			$this->load->view('createspeaker');
			$this->load->view('dashboard/footer');
		}
	}
	public function savespeaker(){
		 $vijay=explode(".",$_FILES["image"]["name"]);
		  $image=time().".".end($vijay);
		  
		   $kumar=explode(".",$_FILES["logo"]["name"]);
		  $logo="l".time().".".end($kumar);
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
						
			$params=array(
				//'page_type' => $this->input->post("page_type"),
				'speaker_name' => $this->input->post("speaker_name"),
				'designation' => $this->input->post("designation"),	
				'country' => $this->input->post("country"),
				'topic' => $this->input->post("topic"),
				'short_dec' => $this->input->post("short_dec"),			
				"image" => $image,
				"logo" => $logo,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			// print_r($params);die();
			$table="{PRE}speakers";
			$speaker=$this->speaker_model->storeItems($table,$params);
			if($speaker == 1)
			{
				
				
				
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				@move_uploaded_file($_FILES['image']['tmp_name'],"includes/uploads/form/".$image);
				@move_uploaded_file($_FILES['logo']['tmp_name'],"includes/uploads/form/".$logo);
				redirect(base_url()."index.php/speaker");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create whyandhow."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/speaker");
			}					
			
		}
	}	
	
	public function editspeaker($speakerid)
	{
		$speakerid=str_replace("_","=",base64_decode($speakerid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="spactive";
			$this->load->view('dashboard/header',$data);
			$data["speakerid"]=$speakerid;
			$speaker=$this->speaker_model->getspeakerid($speakerid);
			$data["speaker"]=$speaker;
			//print_r($speaker);die();			
			$this->load->view('editspeaker',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatespeaker()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
		   $speakerid =$this->input->post('speakerid');

			if(@$_FILES["image"]["name"] != '')
			{						  
				$images=explode(".",$_FILES["image"]["name"]);
				$image=time().".".end($images);				
	   
				$deleteExistimage=$this->speaker_model->removeExistsimage($speakerid);
				if($deleteExistimage > 0)
				{
					@move_uploaded_file($_FILES['image']['tmp_name'],"includes/uploads/form/".$image);					
				}
				else
				{
					$err_banners=array(
					  'err_banners' => "Failed to Update Image."
					);
					$this->session->set_userdata($err_banners);
					redirect(base_url()."index.php/speaker/editspeaker/".str_replace("=","_",base64_encode($speakerid)));
				}     
		
			}
			else
			{
				$image=$this->input->post("hiddenimage");
			}
			
			if(@$_FILES["logo"]["name"] != '')
			{			
				
				$kumar=explode(".",$_FILES["logo"]["name"]);
				$logo="l".time().".".end($kumar);
		   
	   
				$deleteExistimage=$this->speaker_model->removeExistsimage1($speakerid);
				if($deleteExistimage > 0)
				{
					@move_uploaded_file($_FILES['logo']['tmp_name'],"includes/uploads/form/".$logo);					
				}
				else
				{
					$err_banners=array(
					  'err_banners' => "Failed to Update Image."
					);
					$this->session->set_userdata($err_banners);
					redirect(base_url()."index.php/speaker/editspeaker/".str_replace("=","_",base64_encode($speakerid)));
				}     
		
			}
			else
			{
				$logo=$this->input->post("hiddenlogo");
			}
	 
	   //echo  $memberimage;die();
	  $params = array(
			'speaker_name' => $this->input->post("speaker_name"),
			'designation' => $this->input->post("designation"),	
			'country' => $this->input->post("country"),
			'topic' => $this->input->post("topic"),
			'short_dec' => $this->input->post("short_dec"),			
			"logo" => $logo,	
		   'image'=>$image,
		   'created_date' => @date("Y-m-d H:i:s"), 
	   );
	   
	   //print_r($params);die();
	   $table="{PRE}speakers";
	   $speaker=$this->speaker_model->updateItems($table,$params,$speakerid);
	   if($speaker == 1)
	   {
		@move_uploaded_file($_FILES['image']['tmp_name'],"includes/uploads/form/".$image);
		$success_banners=array(
		 'success_speaker' => "Successfully speaker Updated."
		);
		$this->session->set_userdata($success_banners);
		redirect(base_url()."index.php/speaker");
	   }
	   else{
		$err_banners=array(
		 'err_banners' => "Failed to Update banner."
		);
		$this->session->set_userdata($err_banners);
		 redirect(base_url()."index.php/speaker/editspeaker/".str_replace("=","_",base64_encode($speakerid)));
	   }
	   
	  }
	}
	
	
	
	public function deletespeaker($speakerid)
	{
		$speakerid=str_replace("_","=",base64_decode($speakerid));
		$speaker=$this->speaker_model->deletespeaker($speakerid);
		if($speaker == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/speaker");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/speaker");
		}
		
	}
	
	public function inactiveItem($speakerid)
	{
		//$whyandhowid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->speaker_model->itemStatusMode($this->table,$params,$speakerid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/speaker");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/speaker");
		}
	}
	
	public function activeItem($speakerid)
	{
		//$whyandhowid=str_replace("_","=",base64_decode($whyandhowid));
		$params=array(
			"status" => 1
		);
		$success=$this->speaker_model->itemStatusMode($this->table,$params,$speakerid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/whyandhow");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/whyandhow");
		}
	}
	
	
	
	
}

