<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class About extends MX_Controller {
	public $table = "description";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("about_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="abactive";
			$this->load->view('dashboard/header',$data);	
			$about=$this->about_model->getAllbanners();
			$data["about"]=$about;
			$this->load->view('about',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createabout()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="abactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createabout');
			$this->load->view('dashboard/footer');
		}
	}
	public function saveabout()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$pagetype="1";
			$params=array(
				
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}description";
			$about=$this->about_model->storeItems($table,$params);
			if($about == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully about Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/about");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create about."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/about");
			}					
			
		}
	}	
	
	public function editabout($aboutid)
	{
		$aboutid=str_replace("_","=",base64_decode($aboutid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="abactive";
			$this->load->view('dashboard/header',$data);
			$data["aboutid"]=$aboutid;
			$about=$this->about_model->getaboutid($aboutid);
			$data["about"]=$about;
			//print_r($about);die();
	
			$this->load->view('editabout',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updateabout()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$aboutid=$this->input->post("aboutid");
			$pagetype="1";
			$params=array(
				
				'description' => $this->input->post("description"),
				'pagetype' => $pagetype,
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}description";
			$about=$this->about_model->updateItems($table,$params,$aboutid);
			if($about == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  about Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/about");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update about."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/about");
			}
			
		}
	}
	
	
	public function deleteabout($aboutid)
	{
		$aboutid=str_replace("_","=",base64_decode($aboutid));		
		$about=$this->about_model->deleteabout($aboutid);
		if($about == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/about");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/about");
		}
		
	}
	
	public function inactiveItem($aboutid)
	{
		//$aboutid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->about_model->itemStatusMode($this->table,$params,$aboutid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/about");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/about");
		}
	}
	
	public function activeItem($aboutid)
	{
		//$aboutid=str_replace("_","=",base64_decode($aboutid));
		$params=array(
			"status" => 1
		);
		$success=$this->about_model->itemStatusMode($this->table,$params,$aboutid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/about");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/about");
		}
	}
	
	
	
	
}

