<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Broucherdownload extends MX_Controller {
	public $table = "brouchure_users";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("broucherdownload_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index($pagecnt = 0)
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$end=10;
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			
			$totalRecords=$this->broucherdownload_model->getAllbanners();
			$download=$this->broucherdownload_model->getAllbannerswithlimit($pagecnt,$end);

			$this->load->library('pagination');
			$config['base_url'] = base_url().'index.php/broucherdownload/index';
			$config['total_rows'] = @sizeOf($totalRecords);
			$config['per_page'] = $end; 
			$config['first_tag_open']="<div>";
			$config['first_tag_close']="</div>";
			$this->pagination->initialize($config);
			$data["pagination"]=$this->pagination->create_links();				
			
			$data["download"]=$download;
			//print_r($download);die();
			$this->load->view('download',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function deletedownloads($downloadid)
	{
		$downloadid=str_replace("_","=",base64_decode($downloadid));
		$delete=$this->broucherdownload_model->deletedownloads($downloadid);
		if($delete == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/broucherdownload");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/broucherdownload");
		}
		
	}
	
	
	
	
	
	
	
	
}

