<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Comittee extends MX_Controller {
	public $table = "comittee";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("comittee_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			$data["menu"]="ocactive";
			$this->load->view('dashboard/header',$data);
			$comittee=$this->comittee_model->getAllbanners();
			$data["comittee"]=$comittee;
			$this->load->view('comittee',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createcomittee()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="ocactive";
			$this->load->view('dashboard/header',$data);
		
			$this->load->view('createcomittee');
			$this->load->view('dashboard/footer');
		}
	}
	public function savecomittee()
	{
		  $image=explode(".",$_FILES["memberimage"]["name"]);
		  $memberimage=time().".".end($image);
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'membername' => $this->input->post("membername"),
				'designation' => $this->input->post("designation"),
				"memberimage" => $memberimage,
				'country' => $this->input->post("country"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}comittee";
			$comittee=$this->comittee_model->storeItems($table,$params);
			if($comittee == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully comittee Created."
				);
				$this->session->set_userdata($success_categories);
				@move_uploaded_file($_FILES['memberimage']['tmp_name'],"includes/uploads/form/".$memberimage);
				redirect(base_url()."index.php/comittee");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/comittee");
			}					
			
		}
	}	
	
	public function editcomittee($comitteeid)
	{
		$comitteeid=str_replace("_","=",base64_decode($comitteeid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="ocactive";
			$this->load->view('dashboard/header',$data);
			$data["comitteeid"]=$comitteeid;
			$comittee=$this->comittee_model->getcomitteeid($comitteeid);
			$data["comittee"]=$comittee;
			//print_r($address);die();
	
			$this->load->view('editcomittee',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	/*public function updatecomittee()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$comitteeid=$this->input->post("comitteeid");
			
			$params=array(
				
				'membername' => $this->input->post("membername"),
				'designation' => $this->input->post("designation"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}comittee";
			$comittee=$this->comittee_model->updateItems($table,$params,$comitteeid);
			if($comittee == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Comittee Updated."
				);
				$this->session->set_userdata($success_categories);
				
				redirect(base_url()."index.php/comittee");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/comittee");
			}
			
		}
	}*/
	public function updatecomittee()
	{
  if($this->session->userdata("is_logged_in") != 1)
  {
   redirect(base_url()."index.php/login");
  }
  else
  {
	   $comitteeid =$this->input->post('comitteeid');

	   if(@$_FILES["memberimage"]["name"] != '')
	   {
		   
		$images=explode(".",$_FILES["memberimage"]["name"]);
		 $memberimage=time().".".end($images);
	   
		$deleteExistimage=$this->comittee_model->removeExistsimage($comitteeid);
		if($deleteExistimage > 0)
		{
			@move_uploaded_file($_FILES['memberimage']['tmp_name'],"includes/uploads/form/".$memberimage);
		}
		else
		{
		 $err_banners=array(
		  'err_banners' => "Failed to Update Image."
		 );
		 $this->session->set_userdata($err_banners);
		 redirect(base_url()."index.php/comittee/editcomittee/".str_replace("=","_",base64_encode($comitteeid)));
		}     
		
	   }
	   else
	   {
		$memberimage=$this->input->post("hiddenimage");
	   }
	 
	   //echo  $memberimage;die();
	  $params = array(
		'membername' => $this->input->post("membername"),
		'designation' => $this->input->post("designation"),
	   'memberimage'=>$memberimage,
	   'country' => $this->input->post("country"),
	   'created_date' => @date("Y-m-d H:i:s"), 
	   );
	   
	   //print_r($params);die();
	   $table="{PRE}comittee";
	   $comittee=$this->comittee_model->updateItems($table,$params,$comitteeid);
	   if($comittee == 1)
	   {
		@move_uploaded_file($_FILES['memberimage']['tmp_name'],"includes/uploads/form/".$memberimage);
		$success_banners=array(
		 'success_comittee' => "Successfully comittee Updated."
		);
		$this->session->set_userdata($success_banners);
		redirect(base_url()."index.php/comittee");
	   }
	   else{
		$err_banners=array(
		 'err_banners' => "Failed to Update banner."
		);
		$this->session->set_userdata($err_banners);
		 redirect(base_url()."index.php/comittee/editcomittee/".str_replace("=","_",base64_encode($comitteeid)));
	   }
	   
	  }
	}
	
	
	
	
	public function deletecomittee($comitteeid)
	{
		$comitteeid=str_replace("_","=",base64_decode($comitteeid));		
		$comittee=$this->comittee_model->deletecomittee($comitteeid);
		if($comittee == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/comittee");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/comittee");
		}
		
	}
	
	public function inactiveItem($comitteeid)
	{
		//$addressid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->comittee_model->itemStatusMode($this->table,$params,$comitteeid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/comittee");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/comittee");
		}
	}
	
	public function activeItem($comitteeid)
	{
		//$addressid=str_replace("_","=",base64_decode($addressid));
		$params=array(
			"status" => 1
		);
		$success=$this->comittee_model->itemStatusMode($this->table,$params,$comitteeid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/comittee");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/comittee");
		}
	}
	
	
	
	
}

