<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Content extends MX_Controller {
	public $table = "address";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("content_model");
		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			$content=$this->content_model->getAllbanners();
			$data["content"]=$content;
			$this->load->view('content',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createcontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
		
			$this->load->view('createcontent');
			$this->load->view('dashboard/footer');
		}
	}
	public function savecontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$params=array(
				
				'sessionid' => $this->input->post("sessionid"),
				'subtitle' => $this->input->post("subtitle"),
				'description' => $this->input->post("description"),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}sessionscontent";
			$content=$this->content_model->storeItems($table,$params);
			if($content == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully  Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/content");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create address."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/content");
			}					
			
		}
	}	
	
	public function editcontent($contentid)
	{
		$contentid=str_replace("_","=",base64_decode($contentid));
	
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$this->load->view('dashboard/header');
			$data["contentid"]=$contentid;
			$content=$this->content_model->getcontentid($contentid);
			$data["content"]=$content;
			//print_r($address);die();
	
			$this->load->view('editcontent',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatecontent()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$contentid=$this->input->post("contentid");
			
			$params=array(
				
				'sessionId' => $this->input->post("sessionId"),
				'subtitle' => $this->input->post("subtitle"),
				'description' => $this->input->post("description"),
				
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}sessionscontent";
			$content=$this->content_model->updateItems($table,$params,$contentid);
			if($content == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully   Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/content");
			}
			else{
				$err_categories=array(
					'err_categories' => "Failed to Update ."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/content");
			}
			
		}
	}
	
	
	public function deletecontent($contentid)
	{
		$contentid=str_replace("_","=",base64_decode($contentid));		
		$content=$this->content_model->deletecontent($contentid);
		if($content == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/content");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/content");
		}
		
	}
	
	public function inactiveItem($addressid)
	{
		//$addressid=str_replace("_","=",base64_decode($usersid));
		$params=array(
			"status" => 0
		);
		$success=$this->content_model->itemStatusMode($this->table,$params,$contentid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/content");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/content");
		}
	}
	
	public function activeItem($contentid)
	{
		//$addressid=str_replace("_","=",base64_decode($addressid));
		$params=array(
			"status" => 1
		);
		$success=$this->content_model->itemStatusMode($this->table,$params,$contentid);
		if($success == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Updated User Status."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/content");
		}
		else{
			$err_categories=array(
				'err_categories' => "Failed to Update User Status."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/content");
		}
	}
	
	
	
	
}

