<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends MX_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('login_model');
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			$this->load->view('login');
		}
		else
		{
			redirect(base_url()."index.php/dashboard");
		}
	}
	public function verify()
	{
		$params=array(
			'email' => $this->input->post("email"),
			'password' => SHA1($this->input->post("password")),
		);
		//print_r($params);die();
		$check=$this->login_model->checkLogin($params);
		if(@sizeOf($check) > 0)
		{
			$sessionParams=array(
				'userdetails' => $check,
				'userid' => $check[0]->id,
				'usertype' => $check[0]->usertype,
				'is_logged_in' => 1
			);
			$this->session->set_userdata($sessionParams);
			redirect(base_url()."index.php/dashboard");
		}
		else{
			$err_blog=array(
					'err_blog' => "Invalid Email/Password."
				);
			$this->session->set_userdata($err_blog);
			redirect(base_url()."index.php/login");
		}
	}
	
	public function logout()
	{
		$sessionParams=array(
			'userdetails' => '',
			'usertype' => '',
			'is_logged_in' => 0
		);
		$this->session->set_userdata($sessionParams);
		redirect(base_url()."index.php/login");
	}
	
	public function forgot()
	{
		$email=$this->input->post("email");
		$to=$email;
		$superadmin=$this->login_model->getSuperAdminUserDetails();
		$from=$superadmin[0]->email;
		
		$message="<a href='".base_url()."index.php/login/resetpassword/".str_replace("@","%40",$email)."' style='background:#2761AB;color:#fff;padding:5px 10px;margin:10px 0px;text-decoration:none;'>Reset Password</a>";
		
		$userdetails=$this->login_model->getUserDetailsByEmail($to);
		//print_r($userdetails);die();
		$name=$userdetails[0]->firstname;
			
		$msg = "Dear ".$name.",<br /><br />
				Please click below link to Reset Your Password.<br /><br />".$message."<br /><br />Thanks,<br /><br />AQUILUS TEAM.";
				
		$subject= "Reset Password";
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
		// More headers
		$headers .= 'From: '.$from. "\r\n";
		
		$this->_send($to,$subject,$msg,$from);
		
		$err_blog=array(
					'succ_blog' => "Password sent to your Email."
				);
		$this->session->set_userdata($err_blog);
		redirect(base_url()."index.php/login");
	}
	public function forgotcheck(){

		extract($_REQUEST);
		$check=$this->login_model->getUserDetails($forgotemail);
		if(@sizeOf($check) == 1)
		{
			echo 1;
		}
		else{
			echo 0;
		}
	}
	
	public function _send($to,$subject,$msg,$from)
	{
	 
		$config = Array(
		  'mailtype' => 'html', 
		  'charset' => 'utf-8',
		  'wordwrap' => TRUE

		 );
	   $this->load->library('email');
	   $this->email->initialize($config);	
	   $this->email->to($to); 
		$this->email->from($from);	   
	   $this->email->message($msg);	   
	   $this->email->subject($subject);	   
		$this->email->send();
	  
	}
	
	public function resetpassword($email)
	{
		$email=str_replace("%40","@",$email);
		$data["email"]=$email;
		
		$this->load->view('reset',$data);
	}
	
	
	
	public function savepassword()
	{
		$email=$this->input->post("email");
		$params=array(
			'password' => SHA1($this->input->post("password"))
		);
		$uodate=$this->login_model->updateNewPassword($params,$email);
		if($uodate == 1)
		{
			$err_blog=array(
					'succ_blog' => "Your password has been successfully changed."
				);
				$this->session->set_userdata($err_blog);
			redirect(base_url()."index.php/login");
		}
		else
		{
			$err_cities=array(
					'err_cities' => "Failed to change your Password.Please try again"
			);
			redirect(base_url()."index.php/home/resetpassword/".str_replace("@","%40",$email));
		}
	}
}

/* End of file users.php */
/* Location: ./application/modules/users/controllers/users.php */