<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Title extends MX_Controller {
	public $table = "banners";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("title_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["table"]=$this->table;
			
			$data["menu"]="htactive";
			$this->load->view('dashboard/header',$data);	
			$title=$this->title_model->getAllbanners();
			$data["title"]=$title;
			//print_r($title);die();
			$this->load->view('title',$data);
			$this->load->view('dashboard/footer');
		}
	}
	public function createtitle()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="htactive";
			$this->load->view('dashboard/header',$data);
			$this->load->view('create-title');
			$this->load->view('dashboard/footer');
		}
	}
	public function savetitle()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$titledate=$this->input->post('fromdate');
			$titletodate=$this->input->post('todate');
			$params=array(
				'conf_title'=>$this->input->post('title'),
				'fromdate'=>@date('Y-m-d', strtotime($titledate))." ".@date("H:i:s"),
				'todate'=>@date('Y-m-d', strtotime($titletodate)),
				'created_date' => @date("Y-m-d H:i:s"),					
			);
			//print_r($params);die();
			$table="{PRE}title";
			$title=$this->title_model->storeItems($table,$params);
			if($title == 1)
			{	
				
				$success_categories=array(
					'success_categories' => "Successfully Created."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/title");
			}
			else
			{
				$err_categories=array(
					'err_categories' => "Failed to create."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/title");
			}					
			
		}
	}	
	
	public function edittitle($titleid)
	{
		$titleid=str_replace("_","=",base64_decode($titleid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$data["menu"]="htactive";
			$this->load->view('dashboard/header',$data);
			$data["titleid"]=$titleid;
			$title=$this->title_model->gettitleid($titleid);
			$data["title"]=$title;
			//print_r($banners);die();
			
			$this->load->view('edit-title',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function updatetitle()
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{	
			$titleid=$this->input->post("titleid");

			if(@$_FILES["mainImage"]["name"] != '')
			{
				
				$category=explode(".",$_FILES["mainImage"]["name"]);
				$bannersimg=time().".".end($category);
			
				$deleteExistvideo=$this->banners_model->removeExistsvideo($bannersid);
				if($deleteExistvideo == 1)
				{
					@move_uploaded_file($_FILES["mainImage"]["tmp_name"],"includes/uploads/aboutus/".$bannersimg);
				}
				else
				{
					$err_categories=array(
					'err_categories' => "Updation Failed."
					);
					$this->session->set_userdata($err_categories);
					redirect(base_url()."index.php/title/edittitle/".str_replace("=","_",base64_encode($titleid)));
				}					
				
			}
			else
			{
				$bannersimg=$this->input->post("hiddenmainImage");
			}	
				$titledate=$this->input->post('fromdate');
				$titletodate=$this->input->post('todate');
			$params=array(
										
				
				'conf_title'=>$this->input->post('title'),
				'fromdate'=>@date('Y-m-d', strtotime($titledate))." ".@date("H:i:s"),
				'todate'=>@date('Y-m-d', strtotime($titletodate)),
										
				'created_date' => @date("Y-m-d H:i:s"),				
				
			);
			print_r($params);die();
			$table="{PRE}title";
			$title=$this->title_model->updateItems($table,$params,$titleid);
			if($title == 1)
			{
				$success_categories=array(
					'success_categories' => "Successfully Updated."
				);
				$this->session->set_userdata($success_categories);
				redirect(base_url()."index.php/title");
			}
			else{
				$err_categories=array(
					'err_categories' => "Updation Failed."
				);
				$this->session->set_userdata($err_categories);
				redirect(base_url()."index.php/title");
			}
			
		}
	}
	
	
	public function deletetitle($titleid)
	{
		$titleid=str_replace("_","=",base64_decode($titleid));
		$title=$this->title_model->deletetitle($titleid);
		if($title == 1)
		{
			$success_categories=array(
				'success_categories' => "Successfully Deleted."
			);
			$this->session->set_userdata($success_categories);
			redirect(base_url()."index.php/title");
		}
		else
		{
			$err_categories=array(
				'err_categories' => "Failed to Delete."
			);
			$this->session->set_userdata($err_categories);
			redirect(base_url()."index.php/title");
		}
		
	}
	
	
	
	
	
	
}

