<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends MX_Controller {
	public $table = "users";
	public function __construct()
	{
		parent::__construct();
		$this->load->model("users_model");		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
	}
	public function index($pagecnt = 0)
	{
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$end=10;
			$data["table"]=$this->table;
			
			$this->load->view('dashboard/header');	
			
			$totalRecords=$this->users_model->getAllbanners();
			$users=$this->users_model->getAllbannerswithlimit($pagecnt,$end);
			
			$this->load->library('pagination');
			$config['base_url'] = base_url().'index.php/users/index';
			$config['total_rows'] = @sizeOf($totalRecords);
			$config['per_page'] = $end; 
			$config['first_tag_open']="<div>";
			$config['first_tag_close']="</div>";
			$this->pagination->initialize($config);
			$data["pagination"]=$this->pagination->create_links();		
			
			$data["users"]=$users;
			//print_r($users);
			$this->load->view('users',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function view($userid)
	{
		$userid=str_replace("_","=",base64_decode($userid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$this->load->view('dashboard/header');	
			$userinfo=$this->users_model->getAlluserdetails($userid);
			$data["userinfo"]=$userinfo;
			//print_r($users);
			$this->load->view('userinfo',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function views($userid)
	{
		$userid=str_replace("_","=",base64_decode($userid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$this->load->view('dashboard/header');	
			$userinfo=$this->users_model->getAlluserdetailsss($userid);
			$data["userinfo"]=$userinfo;
			//print_r($userinfo);
			$this->load->view('userinfos',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function abstractusers($pagecnt = 0)
	{		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$end=10;
			$this->load->view('dashboard/header');	
			
			$totalRecords=$this->users_model->getAbstractuserdetails();			
			$users=$this->users_model->getAbstractuserdetailswithlimit($pagecnt,$end);
			
			$this->load->library('pagination');
			$config['base_url'] = base_url().'index.php/users/abstractusers';
			$config['total_rows'] = @sizeOf($totalRecords);
			$config['per_page'] = $end; 
			$config['first_tag_open']="<div>";
			$config['first_tag_close']="</div>";
			$this->pagination->initialize($config);
			$data["pagination"]=$this->pagination->create_links();	
			
			
			$data["users"]=$users;
			//print_r($users);
			$this->load->view('abstractusers',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function viewabstract($userid)
	{
		$userid=str_replace("_","=",base64_decode($userid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$this->load->view('dashboard/header');	
			$userinfo=$this->users_model->getAlluserdetailsss($userid);
			$data["userinfo"]=$userinfo;
			//print_r($userinfo);
			$this->load->view('viewabstract',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function discount($pagecnt = 0)
	{		
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			$end=10;
			$this->load->view('dashboard/header');	
			
			$totalRecords=$this->users_model->getdiscountuserdetails();			
			$users=$this->users_model->getdiscountuserdetailswithlimit($pagecnt,$end);

			$this->load->library('pagination');
			$config['base_url'] = base_url().'index.php/users/discount';
			$config['total_rows'] = @sizeOf($totalRecords);
			$config['per_page'] = $end; 
			$config['first_tag_open']="<div>";
			$config['first_tag_close']="</div>";
			$this->pagination->initialize($config);
			$data["pagination"]=$this->pagination->create_links();				
			
			
			$data["users"]=$users;
			//print_r($users);
			$this->load->view('discountusers',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	public function viewdiscount($userid)
	{
		$userid=str_replace("_","=",base64_decode($userid));
		if($this->session->userdata("is_logged_in") != 1)
		{
			redirect(base_url()."index.php/login");
		}
		else
		{
			
			$this->load->view('dashboard/header');	
			$userinfo=$this->users_model->getdiscount($userid);
			$data["userinfo"]=$userinfo;
			//print_r($userinfo);
			$this->load->view('viewdiscount',$data);
			$this->load->view('dashboard/footer');
		}
	}
	
	
	
	
	
	
}

